/* eslint-disable no-console */
import React from 'react';
import { Router, Route, NavLink, Switch } from 'react-router-dom';
import { createBrowserHistory } from 'history';
import { storiesOf } from '@storybook/react';
import FieldEmail from 'modules/issues/components/Timeline/EmailInputContainer';
import { createOpportunitiesFields } from 'modules/issues/components/Timeline/OpportunitiesContainer';
import NewMailForm from '../NewMailForm';
import { NewMailForm as NewMailFormBundle } from '../NewMailForm.bundle/base';
import { NewMailForm as NewMailFormLoadableBundle } from '../NewMailForm.bundle/loadable';

const history = createBrowserHistory();

const signatures = [
  { signatureId: 1, name: 'test 1', bodyHtml: 'test 1', bodyPlain: 'test 1', isDefault: true },
  { signatureId: 2, name: 'test 2', bodyHtml: 'test 2', bodyPlain: 'test 2', isDefault: false },
];

const account = {
  id: 1,
  info: {
    login: '1',
    name: 'account',
  },
};

const templates = [
  {
    bodyHtml: 'bodyHtml 1',
    bodyPlain: 'bodyPlain 2',
    name: 'name 1',
    orderPosition: 0,
    templateId: 1,
    type: 'private',
    typeName: 'private',
    isDefault: false,
  },
  {
    bodyHtml: 'bodyHtml 2',
    bodyPlain: 'bodyPlain 2',
    name: 'name 2',
    orderPosition: 0,
    templateId: 2,
    type: 'common',
    typeName: 'common',
    isDefault: false,
  },
];

const customSubmit = [
  {
    value: 'close',
    content: 'Закрыть',
  },
  {
    value: 'delay',
    content: 'Отложить',
  },
];

const froms = ['crm@yandex-team.ru', 'crm2@yandex-team.ru'];

const emptyFunc = () => {};

const sleep = (ms: number) =>
  new Promise((resolve) => {
    setTimeout(resolve, ms);
  });

const onSubmit = async (values) => {
  await sleep(200);
  console.log(values);
  return values;
};

const onLoad = async () => {
  await sleep(500);
  return {
    froms,
    signatures,
    templates,
    initialValues: {
      id: 1000,
      subject: 'Subject',
    },
  };
};

storiesOf('NewMailForm', module)
  .add('base', () => (
    <NewMailForm
      onSubmit={onSubmit}
      froms={froms}
      EmailInput={FieldEmail(0)}
      signatures={signatures}
      templates={templates}
      onSignatureChange={emptyFunc}
      onTemplateClick={emptyFunc}
    />
  ))
  .add('with all hoc', () => (
    <Router history={history}>
      <div>
        <NavLink to="/unload">unload</NavLink>
      </div>
      <Switch>
        <Route path="/unload">
          <NavLink to="/">back</NavLink>
        </Route>
        <Route path="*">
          <NewMailFormBundle
            onSubmit={onSubmit}
            hasAutoSave
            froms={froms}
            signatures={signatures}
            templates={templates}
            type="new"
            isPreventUnload
            hasDelayedSend
            customSubmitOptions={customSubmit}
            customSubmitPlaceholder="Отправить и закрыть"
          />
        </Route>
      </Switch>
    </Router>
  ))
  .add('loadable', () => (
    <Router history={history}>
      <div>
        <NavLink to="/unload">unload</NavLink>
      </div>
      <Switch>
        <Route path="/unload">
          <NavLink to="/">back</NavLink>
        </Route>
        <Route path="*">
          <NewMailFormLoadableBundle
            onLoad={onLoad}
            onSubmit={onSubmit}
            isPreventUnload
            hasAutoSave
          />
        </Route>
      </Switch>
    </Router>
  ))
  .add('with opportunities', () => (
    <NewMailForm
      onSubmit={onSubmit}
      froms={froms}
      EmailInput={FieldEmail(0)}
      OpportunitiesInput={createOpportunitiesFields({ account })}
      signatures={signatures}
      templates={templates}
      onSignatureChange={emptyFunc}
      onTemplateClick={emptyFunc}
    />
  ));
