import React, { RefObject, ReactNode } from 'react';
import { FormApi } from 'final-form';
import { FormProps } from 'react-final-form';
import { SignatureProps } from 'components/NewMailForm/Signature';
import { TemplatesProps } from 'modules/templates/components/Templates/Template.types';
import { ButtonViewProp } from '@crm/components/dist/lego2/Button/Button';
import Bluebird from 'bluebird';
import { OpportunitiesFieldProps } from './OpportunitiesField/OpportunitiesField.types';

export enum CkeditorMode {
  HTML = 'wysiwyg',
  Plain = 'source',
}

// TODO: add types to ckeditor
// eslint-disable-next-line @typescript-eslint/no-explicit-any
export type Ckeditor = any;

export interface FileInput {
  updateFiles: (fileIds: number[]) => Bluebird<void>;
}

export interface Opportunity {
  id: string;
  name: string;
}

export interface FormValues {
  from?: string;
  to?: string;
  cc?: string;
  bcc?: string;
  subject?: string;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  tagIds?: any[];
  body?: string;
  delayDate?: string;
  mailId?: number;
  noLinkWithOpportunity?: boolean;
  opportunities?: Opportunity[];
}

export type NewMailFormApi = FormApi<FormValues>;

export interface Subject {
  id: number;
  name: string;
  isDefault: boolean;
}

export interface NewMailFormProps extends FormProps<FormValues> {
  objId?: number;
  objectName?: string;
  froms?: string[];
  signatures: SignatureProps['signatures'];
  onSignatureChange: SignatureProps['onChange'];
  templates: TemplatesProps['templates'];
  onTemplateClick: TemplatesProps['onTemplateClick'];
  ckeditorRef?: RefObject<Ckeditor>;
  formApiRef?: RefObject<NewMailFormApi>;
  autoSaveDate?: Date;
  addonBefore?: ReactNode;
  addonAfter?: ReactNode;
  addonBeforeActions?: ReactNode;
  addonAfterActions?: ReactNode;
  hasDelayedSend?: boolean;
  fileInputRef?: RefObject<FileInput>;
  autoFocusEditor?: boolean;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  EmailInput: React.ComponentType<any>;
  OpportunitiesInput?: React.ComponentType<OpportunitiesFieldProps>;
  submitView?: ButtonViewProp;
  subjects?: Subject[];
}
