import React from 'react';
import { Field, useForm } from 'react-final-form';
import { EType } from 'types/entities';
import { buildUrl } from 'utils/buildUrl';
import CheckBox from 'lego/final-form/CheckBox';
import SuggestGrid from 'lego/final-form/SuggestGrid';
import Row from '../Row/Row';
import { OpportunitiesFieldProps } from './OpportunitiesField.types';

export const OpportunitiesField: React.FC<OpportunitiesFieldProps> = (props) => {
  const { RowComponent = Row, account, issueId, mailId, hasNoLinkCheckbox = true } = props;

  const providerUrl = buildUrl('/v0/blocks/opportunity/suggest', {
    accountId: account?.id,
    issueId,
    eType: EType.Mail,
    eId: mailId,
  });

  const form = useForm();

  const opportunitiesField = account?.id && (
    <RowComponent label="Сделки">
      <Field
        name="opportunities"
        component={SuggestGrid}
        account={account}
        initialValue={[]}
        provider={providerUrl}
        title="Привяжите сделки"
      />
    </RowComponent>
  );

  if (!hasNoLinkCheckbox) return opportunitiesField || null;

  return (
    <Field name="noLinkWithOpportunity" subscription={{ value: true }}>
      {(props) => {
        const noLink = props.input.value;
        if (noLink) form.change('opportunities', []);

        return (
          <>
            {!noLink && opportunitiesField}
            <RowComponent>
              <Field
                name="noLinkWithOpportunity"
                component={CheckBox}
                label="Письмо не относится к сделке"
              />
            </RowComponent>
          </>
        );
      }}
    </Field>
  );
};
