import React, { FC } from 'react';
import cx from 'classnames';
import css from './Row.module.css';

interface RowProps {
  label?: string;
  multifield?: boolean;
}

const Row: FC<RowProps> = (props) => {
  const { label, children, multifield } = props;

  return (
    <div className={css.Row}>
      {label && <div className={css.Row__Label}>{label}</div>}
      <div className={cx(css.Row__Field, { [css.Row_multifield]: multifield })}>{children}</div>
    </div>
  );
};

export default Row;
