import React, { useCallback } from 'react';
import { Field } from 'react-final-form';
import DelayedDate from './DelayedDate';

const DelayedDateFinalForm = (props) => {
  const DelayedDateWithAdapter = useCallback(({ input, meta, ...other }) => {
    if (!input.value) {
      return null;
    }

    return (
      <>
        <span>&nbsp;</span>
        <DelayedDate delayedDate={input.value} {...other} />
      </>
    );
  }, []);

  return <Field name="delayDate" component={DelayedDateWithAdapter} {...props} />;
};

export default DelayedDateFinalForm;
