import React from 'react';
import { i18nRaw as createI18NRaw } from '@yandex-int/i18n';
import { FormattedDate } from 'react-intl';
import * as keyset from '../NewMailForm.i18n';

const i18nRaw = createI18NRaw(keyset);

interface Props {
  delayedDate: string;
}

const DelayedDate: React.FC<Props> = ({ delayedDate, ...props }) => (
  <span {...props}>
    {i18nRaw('delayedDate', {
      day: <FormattedDate value={delayedDate} day="numeric" year="numeric" month="numeric" />,
      time: <FormattedDate value={delayedDate} minute="numeric" hour="numeric" />,
    })}
  </span>
);

export default DelayedDate;
