import * as React from 'react';
import createI18N from '@yandex-int/i18n';
import DropdownMenu from 'lego/components/DropdownMenu';
import { SignatureProps } from './Signature.types';
import * as keyset from './Signature.i18n';
import css from './Signature.module.css';

const i18nSignature = createI18N(keyset)('signature');

class Signature extends React.Component<SignatureProps> {
  public static defaultProps = {
    signatures: [],
    size: 's',
  };

  public onChange = (e, signatureId: number) => {
    this.props.onChange(signatureId);
  };

  public render() {
    const { signatures, disabled, size, directions } = this.props;

    const items = signatures.map((signature) => ({
      val: signature.signatureId,
      text: (
        <span className={css.signature}>
          {signature.name != null ? (
            signature.name
          ) : (
            <>
              <span dangerouslySetInnerHTML={{ __html: signature.bodyHtml }} />
              <span className={css.signature__cover} />
            </>
          )}
        </span>
      ),
    }));

    return (
      <DropdownMenu
        onClick={this.onChange}
        size={size}
        disabled={disabled}
        text={i18nSignature}
        items={items}
        maxHeight={400}
        popupClassName={css.popup}
        directions={directions}
      />
    );
  }
}

export default Signature;
