import React, { FC, useCallback, useState } from 'react';
import Dropdown from '@crm/components/dist/lego2/Dropdown';
import Menu from '@crm/components/dist/lego2/Menu';
import { SubjectDropdownProps, MenuChangeEvent } from './SubjectDropdown.types';
import { subjects2Items } from './SubjectDropdown.utils';
import css from './SubjectDropdown.module.css';

const SubjectDropdown: FC<SubjectDropdownProps> = (props) => {
  const { onChange, subjects } = props;

  const [value, setValue] = useState<string>();

  const handleMenuChange = useCallback(
    (event: MenuChangeEvent) => {
      const { value } = event.target;
      setValue(value);
      if (onChange) {
        onChange(value);
      }
    },
    [onChange],
  );

  return (
    <Dropdown
      content={
        <Menu
          className={css.SubjectDropdown__Menu}
          value={value}
          onChange={handleMenuChange}
          items={subjects2Items(subjects)}
        />
      }
    >
      +
    </Dropdown>
  );
};

export default SubjectDropdown;
