import { ItemSimple, MixedItem } from '@yandex-lego/components/Menu';
import { Subject } from '../NewMailForm.types';

export const subject2Item = (subject: Subject): ItemSimple => {
  return {
    value: String(subject.id),
    content: subject.name,
  };
};

export const subjects2Items = (_subjects: Subject[]): MixedItem[] => {
  const subjects = _subjects.slice();
  const defaultSubjectIndex = subjects.findIndex((subj) => subj.isDefault);
  if (defaultSubjectIndex !== -1) {
    const defaultSubject = subjects[defaultSubjectIndex];
    subjects.splice(defaultSubjectIndex, 1);
    const items: MixedItem[] = [
      {
        title: 'Тема по умолчанию',
        items: [subject2Item(defaultSubject)],
      },
    ];
    if (subjects.length) {
      items.push({
        title: 'Дополнительные темы',
        items: subjects.map(subject2Item),
      });
    }

    return items;
  }

  return subjects.map(subject2Item);
};
