import React, { ComponentType, FC, useCallback } from 'react';
import { FieldRenderProps } from 'react-final-form';
import { Subject } from '../NewMailForm.types';
import { SubjectDropdownProps } from './SubjectDropdown.types';

const asFinalFormField = (
  SubjectDropdown: ComponentType<SubjectDropdownProps>,
): ComponentType<FieldRenderProps<string> & SubjectDropdownProps> => {
  const FinalFormField: FC<FieldRenderProps<string> & SubjectDropdownProps> = (props) => {
    const { subjects, input } = props;
    const hasSubjects = Boolean(Array.isArray(subjects) && subjects.length);

    const handleChange = useCallback(
      (subjectId: string) => {
        const subject = (subjects as Subject[]).find((subj) => String(subj.id) === subjectId);
        if (!subject) {
          return;
        }
        input.onChange(subject.name);
      },
      [subjects, input],
    );

    if (!hasSubjects) {
      return null;
    }

    return <SubjectDropdown subjects={subjects as Subject[]} onChange={handleChange} />;
  };

  return FinalFormField;
};

export { asFinalFormField };
