import React, { RefObject } from 'react';
import { Config } from 'final-form';
import { MergeRef } from 'utils/mergeRef';
import { Ckeditor, CkeditorMode } from '../../NewMailForm.types';
import { mode } from './withEditorMode.config';

export interface WithEditorModeProps {
  ckeditorRef?: RefObject<Ckeditor>;
  onSubmit: Config['onSubmit'];
}

export interface WithEditorModeWrappedComponentProps<FormValues = unknown> {
  ckeditorRef?: RefObject<Ckeditor>;
  onSubmit: Config['onSubmit'];
}

export const withEditorMode = <T extends WithEditorModeWrappedComponentProps>(
  WrappedComponent: React.ComponentType<T>,
) => {
  class WithEditorMode extends React.Component<WithEditorModeProps & T> {
    private ckeditorRef = new MergeRef<Ckeditor>();

    // TODO: support callback arg
    private onSubmit: Config['onSubmit'] = (values, formApi) => {
      return this.props.onSubmit({ ...values, [mode]: this.getEditorMode() }, formApi);
    };

    private getEditorMode(): CkeditorMode {
      if (this.ckeditorRef.current) {
        return this.ckeditorRef.current.mode;
      }

      return CkeditorMode.HTML;
    }

    public render() {
      const { ckeditorRef } = this.props;

      this.ckeditorRef.refs = [ckeditorRef];

      return (
        <WrappedComponent {...this.props} ckeditorRef={this.ckeditorRef} onSubmit={this.onSubmit} />
      );
    }
  }

  return WithEditorMode;
};
