import * as React from 'react';

interface Data {
  from?: string;
}

export interface WithFromInitProps {
  froms: string[];
  initialValues?: Data;
}

export const withFromInit = <T extends WithFromInitProps>(
  WrappedComponent: React.ComponentType<T>,
) => {
  const WithFromInit = (props: T) => {
    const { initialValues = {}, froms } = props;

    let patchedInitialValues = initialValues;
    if (!initialValues.from && froms && froms.length) {
      patchedInitialValues = { ...initialValues, from: froms[0] };
    }

    return <WrappedComponent {...props} initialValues={patchedInitialValues} />;
  };

  return WithFromInit;
};
