import * as React from 'react';
import { FormSpy, FormSpyRenderProps } from 'react-final-form';
import Prompt from 'components/Prompt';

export interface WithPreventUnloadProps {
  isPreventUnload?: boolean;
  addonBefore?: React.ReactNode;
}

export const withPreventUnload = <T extends WithPreventUnloadProps>(
  WrappedComponent: React.ComponentType<T>,
) => {
  class WithPreventUnload extends React.Component<T> {
    static defaultProps = {
      isPreventUnload: false,
    };

    private renderSpy = ({ pristine }: FormSpyRenderProps) => {
      const { isPreventUnload } = this.props;
      return <Prompt when={isPreventUnload && !pristine} preventCloseBrowser />;
    };

    private formSpy = (<FormSpy subscription={{ pristine: true }}>{this.renderSpy}</FormSpy>);

    public render() {
      return (
        <WrappedComponent
          {...this.props}
          addonBefore={
            <>
              {this.formSpy}
              {this.props.addonBefore}
            </>
          }
        />
      );
    }
  }

  return WithPreventUnload;
};
