import React, { RefObject } from 'react';
import { FormSpy } from 'react-final-form';
import { FormApi } from 'final-form';
import { MergeRef } from 'utils/mergeRef';
import createI18N from '@yandex-int/i18n';
import Button from '@crm/components/dist/lego2/Button';
import { CustomFormApi } from './withCustomSubmit';
import * as keyset from '../NewMailForm.i18n';

const i18nSaveAsDraft = createI18N(keyset)('saveAsDraft');

export interface WithSaveDraftSubmitProps {
  customFormApiRef?: RefObject<CustomFormApi>;
  saveDraftChildren?: React.ReactNode;
}

export interface WithSaveDraftSubmitWrappedProps<FormValues = unknown> {
  customFormApiRef?: RefObject<FormApi<FormValues>>;
  addonAfterActions?: React.ReactNode;
}

export const withSaveDraftSubmit = <T extends WithSaveDraftSubmitWrappedProps>(
  WrappedComponent: React.ComponentType<T>,
) => {
  class WithSaveDraftSubmit extends React.Component<WithSaveDraftSubmitProps & T> {
    public static defaultProps = {
      saveDraftChildren: i18nSaveAsDraft,
    };

    private customFormApiRef = new MergeRef<CustomFormApi>();

    private handleSaveDraft = () => {
      if (this.customFormApiRef.current) {
        this.customFormApiRef.current.submit({ action: 'draft' });
      }
    };

    public render() {
      const { addonAfterActions, customFormApiRef, saveDraftChildren } = this.props;

      this.customFormApiRef.refs = [customFormApiRef];

      return (
        <WrappedComponent
          {...this.props}
          customFormApiRef={this.customFormApiRef}
          addonAfterActions={
            <>
              {addonAfterActions}
              <FormSpy subscription={{ submitting: true, hasValidationErrors: true }}>
                {({ submitting, hasValidationErrors }) => (
                  <Button
                    disabled={submitting || hasValidationErrors}
                    onClick={this.handleSaveDraft}
                  >
                    {saveDraftChildren}
                  </Button>
                )}
              </FormSpy>
            </>
          }
        />
      );
    }
  }

  return WithSaveDraftSubmit;
};
