import clearSignature from 'utils/mail/clearSignature';
import { File } from 'components/FilesList/types';
import { Tag } from 'types';
import { mode } from '../hoc/withEditorMode';
import { CkeditorMode } from '../NewMailForm.types';

interface Values {
  tags?: Tag[];
  body?: string;
  files?: File[];
}

type ReturnValues<V> = Omit<V, 'tags' | 'files'> & {
  body?: string;
  tagIds?: number[];
};

export interface Options {
  clearBody?: boolean;
}

export default <V extends Values>(values: V, options?: Options): ReturnValues<V> => {
  options = { clearBody: true, ...options };

  const filteredValues: Values = { ...values };

  if (options.clearBody && values[mode] === CkeditorMode.HTML) {
    filteredValues.body = clearSignature(filteredValues.body || '');
  }

  // tags
  const tags = filteredValues.tags;
  delete filteredValues.tags;
  const formattedTags: number[] = [];
  if (tags && tags.length) {
    tags.forEach((item) => {
      formattedTags.push(item.id);
    });
  }

  delete filteredValues.files;

  return {
    ...filteredValues,
    tagIds: formattedTags,
  } as ReturnValues<V>;
};
