import React, { useState, useRef, FC } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import Popup from '@crm/components/dist/lego2/Popup';
import { Direction } from '@crm/components/dist/lego2/Popup';
import { TemplatesMenu } from 'components/TemplatesMenu';
import { TemplatesProps } from './Templates.types';
import css from './Templates.module.css';

const TEMPLATES_POPUP_DIRECTIONS: Direction[] = ['top-left', 'top-center', 'top-right'];

export const Templates: FC<TemplatesProps> = ({ scope, templatesMenuService, onTemplateClick }) => {
  const [show, setShow] = useState(false);
  const buttonRef = useRef<HTMLButtonElement>(null);

  const handleTemplateClick = (value) => {
    setShow(false);
    onTemplateClick(value);
  };

  return (
    <>
      <Button
        icon={(cls) => <Icon className={cls} svg="templates" />}
        title="Подписи и шаблоны"
        area-label="templates"
        view="clear"
        ref={buttonRef}
        onClick={() => setShow(!show)}
      />
      <Popup
        className={css.Templates__popup}
        onOutsideClick={() => setShow(false)}
        visible={show}
        view="default"
        anchor={buttonRef}
        target="anchor"
        scope={scope}
        directions={TEMPLATES_POPUP_DIRECTIONS}
        keepMounted={false}
      >
        <TemplatesMenu
          className={css.Templates__content}
          templatesMenuService={templatesMenuService}
          onTemplateClick={handleTemplateClick}
        />
      </Popup>
    </>
  );
};
