import React, { useState, ComponentType } from 'react';

interface WithShowSecondHeaderFields {
  showSecondHeaderFields: boolean;
  onShowSecondHeaderFields: () => void;
}

export const withShowSecondHeaderFields = <Props extends {} = {}>(
  WrappedComponent: ComponentType<Props & WithShowSecondHeaderFields>,
) => {
  const WithShowSecondHeaderFields = (props: Props) => {
    const [showSecondHeaderFields, setShowSecondHeaderFields] = useState(false);

    return (
      <WrappedComponent
        showSecondHeaderFields={showSecondHeaderFields}
        onShowSecondHeaderFields={() => setShowSecondHeaderFields(!showSecondHeaderFields)}
        {...props}
      />
    );
  };

  return WithShowSecondHeaderFields;
};
