import React, { FC, CSSProperties } from 'react';
import cx from 'classnames';
import Spin from '@crm/components/dist/lego2/Spin';
import { OverlayProps } from './Overlay.types';
import css from './Overlay.module.css';
import { overlayTestId, spinnerTestId } from './Overlay.constants';

const Overlay: FC<OverlayProps> = (props) => {
  const {
    display = false,
    hasSpinner = true,
    color = 'rgba(255, 255, 255, .5)',
    onClick,
    borderRadius,
    children,
    zIndex = 0,
    size = 's',
    className: outerClassName,
    ...restProps
  } = props;

  if (!display) {
    return null;
  }

  const className = cx(css.overlay, outerClassName);
  const style: CSSProperties = { backgroundColor: color, zIndex: zIndex };
  if (borderRadius) {
    style.borderRadius = `${borderRadius}px`;
  }

  return (
    <div
      className={className}
      style={style}
      onClick={onClick}
      {...restProps}
      data-testid={overlayTestId}
    >
      {hasSpinner && (
        <Spin
          className={css.overlay__spin}
          size={size}
          progress
          position="center"
          view="default"
          data-testid={spinnerTestId}
          role="alert"
          aria-busy="true"
        />
      )}
      {children}
    </div>
  );
};

export default Overlay;
