import React, { ComponentType, CSSProperties } from 'react';
import Overlay from '../Overlay';
import { OverlayProps } from '../Overlay.types';

export const withOverlay = (displayPropName: string) => <WCProps extends {}>(
  WC: ComponentType<WCProps>,
  overlayProps: OverlayProps,
  styles: CSSProperties = {},
) => (props: WCProps) => {
  const display = props[displayPropName];
  return (
    <div style={{ position: 'relative', ...styles }}>
      <Overlay display={display} {...overlayProps} />
      <WC {...props} />
    </div>
  );
};
