import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import WordBreak from 'components/WordBreak';
import highlightLink from './highlightLink';
import escapeHTML from './escapeHTML';
import css from './styles.modules.scss';

const PlainText = ({ text, className, link, isHtml }) => {
  if (isHtml) {
    return <WordBreak as="span" className={className} dangerouslySetInnerHTML={{ __html: text }} />;
  }

  let processedText = escapeHTML(text);

  if (link) {
    processedText = highlightLink(processedText);
  }

  return (
    <WordBreak
      as="span"
      className={cx(className, css.plainText)}
      dangerouslySetInnerHTML={{ __html: processedText }}
    />
  );
};

PlainText.propTypes = {
  text: PropTypes.string,
  className: PropTypes.string,
  link: PropTypes.bool,
  isHtml: PropTypes.bool,
};

PlainText.defaultProps = {
  text: '',
  className: undefined,
  link: false,
  isHtml: false,
};

export default PlainText;
