import React, { FC } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import Avatar from 'components/Avatar';
import Icon from '@crm/components/dist/lego2/Icon';
import { PopupItemUserProps } from './PopupItemUser.types';
import css from './PopupItemUser.module.css';

export const PopupItemUser: FC<PopupItemUserProps> = (props) => {
  const { user, isSelected } = props;

  return (
    <div className={css.PopupItemUser}>
      <Avatar theme="round" className={css.PopupItemUser__avatar} size="m" user={user} />
      <div className={css.PopupItemUser__main}>
        <div className={css.PopupItemUser__mainTop}>
          <Text className={css.PopupItemUser__name}>{user.name}</Text>
          {user.login && <Text color="secondary">@{user.login}</Text>}
        </div>
        {user.group && (
          <Text typography="control-m" color="secondary" className={css.PopupItemUser__groupName}>
            {user.group.name}
          </Text>
        )}
      </div>
      {isSelected && <Icon className={css.PopupItemUser__check} svg="check2" svgSize="m" />}
    </div>
  );
};
