import React from 'react';
import { withProps } from 'recompose';
import { CLIENT_TYPE } from 'constants/backendTypes';
import ClientExternalLinks from 'components/ClientExternalLinks';
import ToolTip from 'lego/components/ToolTip';
import StaffCard from 'components/StaffCard';
import AccountLink from 'pages/accounts/components/AccountLink';
import Icon from 'lego/components/Icon';
import PreviewValue from './PreviewValue';
import withArray from './withArray';
import css from './PreviewAccount.scss';

const GET_INFO_SLICE = {
  root: v => v.info,
  info: v => v,
};

const PreviewAccount = props => {
  const {
    className,
    value,
    services,
    size,
    managers,
    level,
    organization,
    login,
    type,
    showPhoneStatus,
    icon,
    theme,
    onClick,
    contentPlaceholder,
    link,
    withTitle,
    withLineHeight = false,
  } = props;

  if (!value) {
    return null;
  }

  const info = GET_INFO_SLICE[level](value);

  if (!info) {
    return null;
  }

  const brackets = [];
  if (login && info.login) {
    brackets.push(info.login);
  }

  if (organization && info.organization) {
    brackets.push(info.organization.name);
  }

  let metaInfo = '';
  if (brackets.length) {
    metaInfo = ` (${brackets.join(', ')})`;
  }

  let typeValue = '';
  if (type && info.type) {
    typeValue = CLIENT_TYPE[info.type] || info.type;
  }

  const linkContent = (
    <React.Fragment>
      {icon && <Icon icon="account_circle" pack="material" />}
      {info.name}
      {metaInfo}
    </React.Fragment>
  );

  const account = (
    <span className={className} title={withTitle && info.name}>
      {link ? (
        <AccountLink accountId={info.id} theme={theme} onClick={onClick}>
          {linkContent}
        </AccountLink>
      ) : (
        linkContent
      )}
      {typeValue && <span>&nbsp;</span>}
      {typeValue && <span className={css.b__type}>{typeValue}</span>}
      {contentPlaceholder}
      {services && <span>&nbsp;</span>}
      {services && (
        <ClientExternalLinks
          key="links"
          client={value}
          size={size}
          withLineHeight={withLineHeight}
        />
      )}
    </span>
  );

  if (managers) {
    const hasManagers = Array.isArray(value.managers) && !!value.managers.length;

    return (
      <ToolTip
        autoZIndex
        hideDelay={300}
        tooltip={
          <div className={css.b__content}>
            <div className={css.b__header}>Менеджеры</div>
            <div className={css.b__list}>
              {hasManagers
                ? value.managers.map(manager => (
                    <div className={css.b__item} key={manager.id}>
                      <StaffCard
                        theme={StaffCard.THEME.YANDEX}
                        user={manager}
                        crmPosition
                        showPhoneStatus={showPhoneStatus}
                      />
                    </div>
                  ))
                : 'Нет менеджеров'}
            </div>
          </div>
        }
      >
        {account}
      </ToolTip>
    );
  }

  return account;
};

PreviewAccount.defaultProps = {
  level: 'root',
  link: true,
};

export const ArrayPreviewAccount = withArray({ slugItems: 'value' })(PreviewAccount);

export default withProps(() => ({
  component: PreviewAccount,
}))(PreviewValue);
