import * as React from 'react';
import { withProps } from 'recompose';
import ClientExternalLinks from 'components/ClientExternalLinks';
import ManagersRow from 'components/Managers';
import PreviewAccount, { ArrayPreviewAccount } from 'components/PreviewValue/PreviewAccount';
import { ArrayPreviewStaff } from 'components/PreviewValue/PreviewStaff';
import infoCss from 'styles/component/info.scss';
import { CLIENT_TYPE } from 'constants/backendTypes';
import css from './PreviewAccountBlock.module.css';
import PreviewValue from './PreviewValue';

interface Props {
  className?: string;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  value?: any; // todo: describe backend account type
  showPhoneStatus?: boolean;
}

const PreviewAccountBlock = (props: Props): React.ReactElement | null => {
  const { className, value, showPhoneStatus } = props;

  if (!value) {
    return null;
  }

  const { info, agency, managers } = value;
  if (!info) {
    return null;
  }

  const { tier, freezeTier, freezeManager, type } = info;

  return (
    <div className={className}>
      <div className={css.row}>
        {info.name}
        {info.login && ` (${info.login})`}
      </div>
      {agency && (
        <div className={css.agency}>
          <span className={css.subClient}>Агентство</span>&nbsp;
          <PreviewAccount value={agency} organization managers />
        </div>
      )}
      <ClientExternalLinks className={css.serviceLinks} client={value} />
      {type && (
        <div className={infoCss.group}>
          <span className={infoCss.label}>Тип аккаунта</span>
          <span className={infoCss.field}>{CLIENT_TYPE[type]}</span>
        </div>
      )}
      {tier && (
        <div className={infoCss.group}>
          <span className={infoCss.label}>Tier</span>
          <span className={infoCss.field}>{tier.name}</span>
        </div>
      )}
      {freezeTier && (
        <div className={infoCss.group}>
          <span className={infoCss.label}>Tier заморозки</span>
          <span className={infoCss.field}>{freezeTier.name}</span>
        </div>
      )}
      {managers && <ManagersRow managers={managers} showPhoneStatus={showPhoneStatus} />}
      {freezeManager && (
        <div className={infoCss.group}>
          <span className={infoCss.label}>Менеджер заморозки</span>
          <span className={infoCss.field}>
            <ArrayPreviewStaff value={freezeManager} />
          </span>
        </div>
      )}
      {Array.isArray(info.contractors) && (
        <div className={infoCss.group}>
          <span className={infoCss.label}>Контрагенты</span>
          <span className={infoCss.field}>
            <ArrayPreviewAccount
              value={info.contractors}
              organization
              managers
              showPhoneStatus={showPhoneStatus}
            />
          </span>
        </div>
      )}
    </div>
  );
};

export const PreviewAccountBlockWithEmpty = withProps(() => ({
  component: PreviewAccountBlock,
}))(PreviewValue);

export default PreviewAccountBlock;
