import React from 'react';
import { mapProps } from 'recompose';
import Icon from 'lego/components/Icon';
import PreviewValue from './PreviewValue';

const VALUE_MAPPER = new Map();
VALUE_MAPPER.set(true, <Icon pack={Icon.PACKS.FONTAWESOME} icon="check" />);
VALUE_MAPPER.set(false, <Icon pack={Icon.PACKS.FONTAWESOME} icon="times" />);

export default mapProps(props => {
  const { value } = props;

  return { ...props, value: VALUE_MAPPER.get(value) };
})(PreviewValue);
