import React from 'react';
import { withProps } from 'recompose';
import { FormattedDate } from 'react-intl';
import PreviewValue from './PreviewValue';

interface Props {
  value: string;
  time?: boolean;
  timeOnly?: boolean;
}

const SETTINGS = {
  FULL: {
    year: 'numeric',
    month: 'short',
    day: 'numeric',
  },
  SHORT: {
    month: 'short',
    day: 'numeric',
  },
};

const DateComponent = ({ value, time, timeOnly }: Props) => {
  const date = new Date(value);

  if (Number.isNaN(date.getTime())) {
    return null;
  }

  let config;

  if (timeOnly) {
    config = { hour: 'numeric', minute: 'numeric' } as any;
  } else {
    const now = new Date();

    config = date.getFullYear() === now.getFullYear() ? SETTINGS.SHORT : SETTINGS.FULL;

    if (time) {
      config = { ...config, hour: 'numeric', minute: 'numeric' } as any;
    }
  }

  return <FormattedDate value={date} {...config} />;
};

export default withProps(() => ({
  component: DateComponent,
}))(PreviewValue);
