import { mapProps } from 'recompose';
import PreviewValue from './PreviewValue';
import withArray from './withArray';

const PreviewDictinary = mapProps(({ fieldName = 'name', ...props }) => ({
  ...props,
  value: (props.value || {})[fieldName],
}))(PreviewValue);

export const ArrayPreviewDictionary = withArray({ slugItems: 'value', isSupportSingleValue: true })(
  PreviewDictinary,
);

export default PreviewDictinary;
