import React, { FC, ReactNode } from 'react';
import { MoneyValue } from 'types/api/form/Fields/Money';
import { PreviewMoneyProps } from './PreviewMoney.types';

const moneyValueToString = (value: MoneyValue): string => {
  const strParts: (number | string)[] = [];
  strParts.push(value.value || 0);

  if (value.currency) {
    strParts.push(value.currency.name);
  }

  return strParts.join(' ');
};

export const PreviewMoney: FC<PreviewMoneyProps> = ({ className, value }) => {
  let content: ReactNode = '–';

  if (value) {
    content = moneyValueToString(value);
  }

  return <span className={className}>{content}</span>;
};
