import { withProps, renameProp } from 'recompose';
import StaffCard from 'components/StaffCard';
import Avatar from 'components/Avatar';
import PreviewValue from './PreviewValue';
import withArray from './withArray';

const AdapterStaffCard = renameProp('value', 'user')(StaffCard);

const AVATART_PROPS = {
  theme: 'round',
  component: Avatar,
  componentWithEmpty: true,
};

const PreviewStaff = withProps(props => {
  let passProps = {
    component: AdapterStaffCard,
  };

  if (props.theme === 'avatar' && !props.value) {
    passProps = AVATART_PROPS;
  }

  return passProps;
})(PreviewValue);

export const ArrayPreviewStaff = withArray({ slugItems: 'value', isSupportSingleValue: true })(
  PreviewStaff,
);

export default PreviewStaff;
