import { mapProps } from 'recompose';
import PreviewValue from './PreviewValue';

export default mapProps(props => {
  const { value } = props;

  let result;
  if (value) {
    result = value.name || '';

    if (value.resolution) {
      result += ` (${value.resolution.name})`;
    }
  }

  return { ...props, value: result };
})(PreviewValue);
