import React, { ComponentType } from 'react';
import css from './PreviewValue.scss';

interface Props {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  value: any;
  className?: string;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  component?: ComponentType<any>;
  componentWithEmpty?: boolean;
  placeholder?: React.ReactNode;
  contentPlaceholder?: React.ReactNode;
  contentPlaceholderWhenEmpty?: boolean;
  [key: string]: unknown;
}

export const PreviewValue = (props: Props) => {
  const {
    value,
    className,
    component,
    placeholder,
    componentWithEmpty,
    contentPlaceholder,
    contentPlaceholderWhenEmpty = true,
    ...other
  } = props;

  let renderedValue: React.ReactNode = null;
  let needContentPlaceholder = true;
  if (
    componentWithEmpty ||
    !(value == null || value === '' || value === 'None' || (Array.isArray(value) && !value.length))
  ) {
    if (component) {
      renderedValue = React.createElement(component, { value, contentPlaceholder, ...other });
      needContentPlaceholder = false;
    } else {
      renderedValue = value;
    }
  } else {
    if (placeholder) {
      renderedValue = <span className={css.b__placeholder}>{placeholder}</span>;
    } else {
      renderedValue = <span>&mdash;</span>;
    }

    needContentPlaceholder = contentPlaceholderWhenEmpty;
  }

  return (
    <span className={className}>
      {renderedValue}
      {needContentPlaceholder && contentPlaceholder}
    </span>
  );
};

export default PreviewValue;
