import { mapProps, withProps } from 'recompose';
import WikiFormatter, { withSuspense } from 'components/WikiFormatter';
import PreviewValue from './PreviewValue';

const WikiAdapter = mapProps((props) => {
  let value = props.value || {};
  if (typeof value === 'object') {
    value = value.markdown;
  }

  return {
    markdown: value,
    ...props,
    value: undefined,
  };
})(withSuspense(WikiFormatter));

export default withProps(() => ({
  component: WikiAdapter,
}))(PreviewValue);
