/* eslint-disable jsx-a11y/no-static-element-interactions,jsx-a11y/click-events-have-key-events */
import React, { useCallback, MouseEvent } from 'react';
import { useDispatch } from 'react-redux';
import { setEObject } from 'modules/issuePreview/redux/previewSlice';
import { Type } from 'modules/issuePreview/types';
import css from './TrackerKey.module.css';

interface Props {
  value: string;
}

const TrackerKey: React.FC<Props> = ({ value }) => {
  const dispatch = useDispatch();

  const onClick = useCallback(
    (e: MouseEvent<HTMLDivElement>) => {
      e.stopPropagation();
      // stopPropagation for native event on document
      e.nativeEvent.stopImmediatePropagation();

      dispatch(setEObject({ id: value, type: Type.Tracker }));
    },
    [value],
  );

  return (
    <div className={css.b} onClick={onClick}>
      {value}
    </div>
  );
};

export default TrackerKey;
