/* eslint-disable react/no-array-index-key */

import React from 'react';

const withArray = (config) => (WrappedComponent) => {
  const WithArray = (props) => {
    const {
      slugItems,
      getId,
      slugValue,
      component: Component,
      props: componentProps,
      isSupportSingleValue,
      ...other
    } = props;

    const value = props[slugItems];
    delete other[slugItems];

    if (Array.isArray(value) && value.length) {
      const renderValue = [];
      value.forEach((item, index) => {
        const key = getId(item);

        if (index !== 0) {
          renderValue.push(<span key={`comma_${key}`}>, </span>);
        }
        renderValue.push(
          <Component key={key} {...{ [slugValue]: item }} {...other} {...componentProps} />,
        );
      });

      return renderValue;
    }

    if (isSupportSingleValue && value && value.id != null) {
      return <Component {...{ [slugValue]: value }} {...other} {...componentProps} />;
    }

    return '\u2014';
  };

  WithArray.defaultProps = {
    getId: (item) => item.id,
    slugValue: 'value',
    slugItems: 'items',
    component: WrappedComponent,
    isSupportSingleValue: false,
    ...config,
  };

  return WithArray;
};

export default withArray;
