import * as React from 'react';
import { Prompt as PromptBase } from 'react-router-dom';
import createI18N from '@yandex-int/i18n';
import { forceChangeLocationFlag } from 'services/ForceChangeLocationFlag';
import * as keyset from './Prompt.i18n';

const i18nActionConfirm = createI18N(keyset)('actionConfirm');

interface Props {
  message: string;
  when?: boolean;
  preventCloseBrowser: boolean;
  preventChangeLocation?: boolean;
}

class Prompt extends React.Component<Props> {
  public static defaultProps = {
    message: i18nActionConfirm,
    preventCloseBrowser: false,
    preventChangeLocation: true,
  };

  public componentDidMount() {
    window.addEventListener('beforeunload', this.handleCloseBrowser);
  }

  public componentWillUnmount() {
    window.removeEventListener('beforeunload', this.handleCloseBrowser);
  }

  private handleCloseBrowser = (event: BeforeUnloadEvent) => {
    if (this.props.preventCloseBrowser && this.props.when) {
      const { message } = this.props;
      event.returnValue = message; // Gecko + IE
      return message; // Webkit, Safari, Chrome etc.
    }

    return null;
  };

  private handleChangeLocation = () => {
    if (forceChangeLocationFlag.next) {
      return true;
    }

    return this.props.message;
  };

  public render() {
    if (!this.props.preventChangeLocation) {
      return null;
    }

    return <PromptBase {...this.props} message={this.handleChangeLocation} />;
  }
}

export default Prompt;
