import React from 'react';
import { connect } from 'react-redux';
import { reduxForm, Field } from 'redux-form';
import { storiesOf } from '@storybook/react';
import Textinput from '@crm/components/dist/lego2/Textinput';
import FastTextInput from 'lego/redux-form/FastTextInput';
import Group from 'modules/groups';
import ReactBuilder from './index';

const Form = ({ children }) => <form>{children}</form>;

const ReduxForm = reduxForm<{}, { children: React.ReactNode }>({})(Form);

const components = {
  ReduxForm,
  Textinput,
  Group,
  Field,
};

interface State {
  value: string;
}

class ControlledInput extends React.Component<{}, State> {
  public constructor(props) {
    super(props);

    this.state = { value: '' };
  }

  private handleChange = (e) => {
    this.setState({ value: e.target.value });
  };

  public render() {
    return <input type="text" value={this.state.value} onChange={this.handleChange} />;
  }
}

const ReduxControlledInput = connect()(ControlledInput);

const nativeHtml = new Array(300)
  .fill(true)
  .map(() => '<input />')
  .join('');

const meta = {
  component: 'div',
  content: [
    {
      component: 'Group',
      props: {
        header: 'nativeHtml',
        name: 'nativeHtml',
      },
      content: [
        {
          component: 'div',
          props: {
            dangerouslySetInnerHTML: { __html: nativeHtml },
          },
        },
      ],
    },
    {
      component: 'Group',
      props: {
        header: 'native',
        name: 'native',
      },
      content: new Array(300).fill(1).map(() => ({
        component: 'input',
      })),
    },
    {
      component: 'Group',
      props: {
        header: 'nativeControlled',
        name: 'nativeControlled',
      },
      content: new Array(300).fill(1).map(() => ({
        component: ReduxControlledInput,
      })),
    },
    {
      component: 'Group',
      props: {
        header: 'ReduxFormNative',
        name: 'ReduxFormNative',
      },
      content: [
        {
          component: 'ReduxForm',
          props: {
            form: 'ReduxFormNative',
          },
          content: new Array(300).fill(1).map((_, index) => ({
            component: 'Field',
            key: index,
            props: {
              component: 'input',
              name: `test${index}`,
            },
          })),
        },
      ],
    },
    {
      component: 'Group',
      props: {
        header: 'TextInput',
        name: 'TextInput',
      },
      content: new Array(300).fill(1).map(() => ({
        component: 'TextInput',
      })),
    },
    {
      component: 'Group',
      props: {
        header: 'ReduxFormFastTextInput',
        name: 'ReduxFormFastTextInput',
      },
      content: [
        {
          component: 'ReduxForm',
          props: {
            form: 'FastTextInput',
          },
          content: new Array(300).fill(1).map((_, index) => ({
            component: 'Field',
            key: index,
            props: {
              component: FastTextInput,
              name: `test${index}`,
            },
          })),
        },
      ],
    },
  ],
};

storiesOf('ReactBuilder', module).add('with text', () => (
  <ReactBuilder meta={meta} components={components} />
));
