import * as React from 'react';
import PropTypes from 'prop-types';
import createReactTree from './createReactTree';
import { Props } from './types';

interface State {
  error: boolean;
}

class ReactBuilder extends React.PureComponent<Partial<Props>, State> {
  public static childContextTypes = {
    components: PropTypes.instanceOf(Object).isRequired,
  };

  public constructor(props) {
    super(props);

    this.state = { error: false };
  }

  public getChildContext() {
    return { components: this.props.components };
  }

  public componentDidCatch(error) {
    console.error(error);
    this.setState({ error: true });
  }

  public render() {
    if (this.state.error) {
      return <span>Error in render ReactBuilder</span>;
    }

    if (!this.props.meta || !this.props.components) {
      return null;
    }

    return createReactTree(this.props as Props);
  }
}

export default ReactBuilder;
