import * as React from 'react';
import { Props, Components, Node, NodeComponent } from './types';

/* todo: need refactor without recursion */

const factoryCreateReactNode = (components: Components) => {
  const createReactNode = ({ component, props, content }: Node) => {
    if (!component) {
      return null;
    }

    let formattedComponent: NodeComponent = component;

    if (typeof component === 'string' && components[component]) {
      formattedComponent = components[component];
    }

    let renderedChildren;
    if (content != null) {
      if (Array.isArray(content)) {
        renderedChildren = content.map((node, index) => (
          <React.Fragment key={index}>{createReactNode(node)}</React.Fragment>
        ));
      } else if (typeof content === 'object') {
        renderedChildren = createReactNode(content);
      } else {
        renderedChildren = content;
      }
    }

    return React.createElement(formattedComponent, props, renderedChildren);
  };

  return createReactNode;
};

const createReactTree: (props: Props) => React.ReactNode = (props) => {
  const { meta, components } = props;

  const createReactNode = factoryCreateReactNode(components);

  return createReactNode(meta);
};

export default createReactTree;
