import React, { FC } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import { RetryButtonProps } from './RetryButton.types';

export const RetryButton: FC<RetryButtonProps> = ({
  onRetry,
  iconLeft = (cls) => <Icon className={cls} svg="refresh16" />,
  children = 'Повторить',
  view = 'clear',
  ...props
}) => (
  <Button iconLeft={iconLeft} onClick={onRetry} view={view} {...props}>
    {children}
  </Button>
);
