import React from 'react';
import cx from 'classnames';
import { lazyWithSuspense } from 'components/lazyWithSuspense';
import { EditorProps } from './RichHtmlEditor.types';
import css from './RichHtmlEditor.module.css';

const RichHtmlEditorAsync = lazyWithSuspense(() =>
  import(/* webpackChunkName: "ckeditor-bundle" */ './RichHtmlEditor'),
);

export const RichHtmlEditor: React.FC<EditorProps> = (props) => {
  const { className, height, theme, resizable, textAreaPadding = true } = props;

  return (
    <RichHtmlEditorAsync
      {...props}
      fallback={
        <div
          className={cx(css.b, className, css[`b_height_${height}`], css[`b_theme_${theme}`], {
            [css.b_resizable]: resizable,
            [css.b_padding]: textAreaPadding,
          })}
        />
      }
    />
  );
};

export const getCKEDITOR = () => {
  return import(/* webpackChunkName: "ckeditor-bundle" */ './RichHtmlEditor').then(
    () => global.CKEDITOR,
  );
};
