// TODO: add types to ckeditor
// eslint-disable-next-line @typescript-eslint/no-explicit-any
export interface Ckeditor extends Record<string, any> {
  mode?: string;
  on: (name, callback) => void;
  destroy: () => void;
  getData: () => string;
  fire: (eventName: string) => void;
  setData: (data: string) => void;
  focus: () => void;
}

export type EditorRef = Ckeditor;
export interface EditorProps {
  value?: string;
  defaultValue?: string;
  startupMode?: string;
  resizable?: boolean;
  autogrow?: boolean;
  defaultHeight?: number;
  height?: 'fix' | 'auto';
  name?: string;
  editorConfig?: Record<string, unknown>;
  focus?: boolean;
  onBlur?: (text: string) => void;
  onChange?: (text: string) => void;
  /** @deprecated use onInstanceReady */
  onMount?: (editor: Ckeditor) => void;
  onInstanceReady?: (editor: Ckeditor) => void;
  onFocus?: (...args) => void;
  resizeHash?: boolean | number | string;
  caretStartOnFocus?: boolean;
  theme?: 'inline';
  className?: string;
  textAreaPadding?: boolean;
  keepLinesInPlainText?: boolean;
  ckeditorRef?: React.MutableRefObject<Ckeditor | null>;
}
