import getCrmConfig from 'entry/utils/getCrmConfig';
import ckeditorConfig from './config'
import getCsrfToken from 'api/getCsrfToken';
import { getCsrfTokenFrontend } from 'api/getCsrfTokenFrontend';
import './skins/clean/editor.css';

require('ckeditor/dist/ckeditor-full.js');

// заглушаем openDialog у ckeditor-full.js, чтобы плагин dialog смог ее переопределить
CKEDITOR.editor.prototype.openDialog = undefined

require('./srcPlugins').default();
require('./plugins').default();

require('./lang');

CKEDITOR.plugins.load('switchmode', () => {
    CKEDITOR.plugins.setLang('switchmode', 'ru', {
      disable: 'Текстовый режим',
      enable: 'Оформить письмо',
      confirm: 'Отключение форматирования используется исключительно по просьбе клиента',
    });
  });
  
CKEDITOR.plugins.setLang('pastefile', 'ru', {
    inlinePlaceholder: 'Вставьте файл прямо в текст',
    attachPlaceholder: 'Перетащите файл сюда',
});

CKEDITOR.on( 'instanceReady', function( ev ) {
  ev.editor.on( 'fileUploadRequest', function( evt ) {
    const { fileLoader } = evt.data;
    const formData = new FormData();
    const { xhr } = fileLoader;

    // фомрмируется запрос для отправки inline-attach на сервер
    xhr.open('POST', fileLoader.uploadUrl, true);
    xhr.setRequestHeader('X-Csrf-Token', getCsrfToken());
    xhr.setRequestHeader('X-Csrf-Token-Frontend', getCsrfTokenFrontend());
    formData.append('upload', fileLoader.file, fileLoader.fileName);
    fileLoader.xhr.send(formData);
    evt.stop();
  })
})

CKEDITOR.config = Object.assign({}, CKEDITOR.config, ckeditorConfig);
CKEDITOR.env.nonce = (getCrmConfig() || {}).nonce;
