import React from 'react';
import createI18N from '@yandex-int/i18n';
import cx from 'classnames';
import * as keyset from 'components/RichHtmlEditor/RichHtmlEditor.i18n';
import './collapsedQuotes.css';

import { EXPAND_QUOTE_CLASS, EXPAND_ALL_QUOTES_CLASS } from './constants';

const i18n = createI18N(keyset);
const i18nExpandAllQuotes = i18n('expandAllQuotes');
const i18nExpandQuote = i18n('expandQuote');
const i18nExpandQuotePlus = i18n('expandQuotePlus');

interface Props {
  level: number;
  totalCount: number;
}

export default class QuoteToggler extends React.PureComponent<Props> {
  private mayBeRenderExpandAllQuotes() {
    const { level, totalCount } = this.props;

    const className = cx('mail-Compose-Quote-Toggler', EXPAND_ALL_QUOTES_CLASS);

    return level > 0 && totalCount > 1 && <div className={className}>{i18nExpandAllQuotes}</div>;
  }

  private renderExpandQuote() {
    const { level } = this.props;

    const className = cx('mail-Compose-Quote-Toggler', EXPAND_QUOTE_CLASS);

    return (
      <div className={className} data-level={level}>
        {this.renderExpandQuoteText()}
      </div>
    );
  }

  private renderExpandQuoteText() {
    const { level } = this.props;

    return level === 0 ? i18nExpandQuote : i18nExpandQuotePlus;
  }

  public render() {
    const { totalCount } = this.props;

    return (
      <div className="mail-Compose-Quote-Toggle-Container" data-levels-count={totalCount}>
        {this.renderExpandQuote()}
        {this.mayBeRenderExpandAllQuotes()}
      </div>
    );
  }
}
