import { QUOTE_TAG } from '../constants';
import { uniq } from 'lodash';

export default function calcQuoteLevelsCount(node) {
    if (!node) {
        return 0;
    }

    const quotes = Array.prototype.slice.call(node.getElementsByTagName(QUOTE_TAG));
    const parents = quotes.map(quote => quote.parentNode);
    const sublevelsCount = uniq(parents).length;

    const isRootQuote = node.tagName.toLowerCase() === QUOTE_TAG.toLowerCase();

    return isRootQuote
        ? sublevelsCount + 1
        : sublevelsCount;
}
