import { QUOTE_TAG } from '../constants';

import extractText from './extractText';
import replaceNode from './replaceNode';
import calcQuoteLevelsCount from './calcQuoteLevelsCount';

const WEIGHT_ATTR = 'data-weight';

function getClosestParentQuote(node) {
    let parent = node && node.parentNode;

    while (parent) {

        if (parent.tagName.toUpperCase() === QUOTE_TAG.toUpperCase()) {
            return parent;
        }

        parent = parent.parentNode;
    }

    return null;
}

function getQuoteWeight(quote) {
    let weight = quote.getAttribute(WEIGHT_ATTR);

    if (!weight) {
        const level = calcQuoteLevelsCount(quote);
        const length = extractText(quote).length;

        weight = level * 10000 + length;

        quote.setAttribute(WEIGHT_ATTR, weight);
    }

    return weight;
}

export default function extractQuotes(node, replacement) {
    if (!node) {
        return null;
    }

    const quotes = Array.prototype.slice.call(node.getElementsByTagName(QUOTE_TAG))
        .filter(q => {
            const closestParentQuote = getClosestParentQuote(q);
            // либо прямой потомок нашей ноды
            // либо первый по иерархии blockquote (выдираем только цитаты)
            return !closestParentQuote || closestParentQuote === node;
        })
        .map((quote) => ({ quote, weight: getQuoteWeight(quote) }))
        .sort((a, b) => a.weight - b.weight);

    let quoteNode = null;
    if (quotes.length) {
        quoteNode = quotes[quotes.length - 1].quote;
        replaceNode(quoteNode, replacement);
    }

    return quoteNode;
}
