import React from 'react';
import ReactDom from 'react-dom';

import QuoteToggler from './QuoteToggler';
import { QUOTE_TAG, QUOTE_CONTAINER_CLASS } from './constants';

export function renderQuoteToggler({
    lang,
    level,
    totalCount
}) {
    const result = document.createElement(QUOTE_TAG);
    result.attributes['type'] = 'cite';
    result.contentEditable = false;
    result.classList.add('b-quote');
    result.classList.add(QUOTE_CONTAINER_CLASS);

    ReactDom.render(
        <QuoteToggler
            lang={ lang }
            level={ level }
            totalCount={ totalCount }
        />,
        result);
    
    return result;
}

export function unmountQuoteToggler(node) {
    ReactDom.unmountComponentAtNode(node);
}
