function extractText(node) {
    return node.innerText || '';
}

export default class HebrewSwitcher {

    editor = null;
    textWatcher = null;

    _subscriptions = [];

    constructor(editor) {
        this.editor = editor;

        this.textWatcher = new CKEDITOR.plugins.textWatcher(
            this.editor,
            this.onTextChanged,
            10
        );

        this.setWatcherState(true);

        this._addSubscription('destroy', this._onDestroy);
        this._addSubscription('beforeSetMode', this._onBeforeModeChange);
        this._addSubscription('afterPaste', this.onTextChanged);
    }

    _addSubscription(eventName, ...args) {
        this._subscriptions.push(
            this.editor.on(eventName, ...args)
        );
    }

    _onDestroy = () => {
        this._subscriptions.forEach(
            (subscription) => subscription.removeListener()
        );

        this.setWatcherState(false);
    };

    _onBeforeModeChange = ({ data }) => {
        this.setWatcherState(data !== 'source');
    };

    setWatcherState(isEnable) {
        this.textWatcher.destroy();

        if (isEnable) {
            this.textWatcher.attach();
        }
    }
    
    onTextChanged = () => {
        const content = this.editor.container.find('.cke_wysiwyg_div div').$;
        if (!content) {
            return;
        }

        for (let i = 0; i < content.length; i++) {
            const paragraph = content[i];

            const text = extractText(paragraph);
            const isRTL = /[א-ת]/.test(text);

            if (isRTL) {
                paragraph.style.setProperty('direction', 'rtl');
            } else {
                paragraph.style.removeProperty('direction');

                if (getComputedStyle(paragraph).direction === 'rtl') {
                    paragraph.style.setProperty('direction', 'ltr');
                }
            }
        }
    }
}
