﻿( function() {
	function protectFormStyles( formElement ) {
		if ( !formElement || formElement.type != CKEDITOR.NODE_ELEMENT || formElement.getName() != 'form' )
			return [];

		var hijackRecord = [],
			hijackNames = [ 'style', 'className' ];
		for ( var i = 0; i < hijackNames.length; i++ ) {
			var name = hijackNames[ i ];
			var $node = formElement.$.elements.namedItem( name );
			if ( $node ) {
				var hijackNode = new CKEDITOR.dom.element( $node );
				hijackRecord.push( [ hijackNode, hijackNode.nextSibling ] );
				hijackNode.remove();
			}
		}

		return hijackRecord;
	}

	function restoreFormStyles( formElement, hijackRecord ) {
		if ( !formElement || formElement.type != CKEDITOR.NODE_ELEMENT || formElement.getName() != 'form' )
			return;

		if ( hijackRecord.length > 0 ) {
			for ( var i = hijackRecord.length - 1; i >= 0; i-- ) {
				var node = hijackRecord[ i ][ 0 ];
				var sibling = hijackRecord[ i ][ 1 ];
				if ( sibling )
					node.insertBefore( sibling );
				else
					node.appendTo( formElement );
			}
		}
	}

	function saveStyles( element, isInsideEditor, ignoredClasses ) {
		var data = protectFormStyles( element );
		var retval = {};

		var $element = element.$;

		if ( !isInsideEditor ) {
			retval[ 'class' ] = $element.className || '';

			if (ignoredClasses) {
				$element.className = ( retval[ 'class' ].match(ignoredClasses) || [] ).join('');

			} else {
				$element.className = '';
			}
		}

		retval.inline = $element.style.cssText || '';
		if ( !isInsideEditor ) // Reset any external styles that might interfere. (#2474)
		$element.style.cssText = 'position: static; overflow: visible';

		restoreFormStyles( data );
		return retval;
	}

	function restoreStyles( element, savedStyles ) {
		var data = protectFormStyles( element );
		var $element = element.$;
		if ( 'class' in savedStyles )
			$element.className = savedStyles[ 'class' ];
		if ( 'inline' in savedStyles )
			$element.style.cssText = savedStyles.inline;
		restoreFormStyles( data );
	}

	function refreshCursor( editor ) {
		if ( editor.editable().isInline() )
			return;

		// Refresh all editor instances on the page (#5724).
		var all = CKEDITOR.instances;
		for ( var i in all ) {
			var one = all[ i ];
			if ( one.mode == 'wysiwyg' && !one.readOnly ) {
				var body = one.document.getBody();
				// Refresh 'contentEditable' otherwise
				// DOM lifting breaks design mode. (#5560)
				body.setAttribute( 'contentEditable', false );
				body.setAttribute( 'contentEditable', true );
			}
		}

		if ( editor.editable().hasFocus ) {
			editor.toolbox.focus();
			editor.focus();
		}
	}

	CKEDITOR.plugins.add( 'maximize', {
		hidpi: true,

		init: function( editor ) {
			// Maximize plugin isn't available in inline mode yet.
			if ( editor.elementMode == CKEDITOR.ELEMENT_MODE_INLINE )
				return;

			var lang = editor.lang;
			var mainDocument = CKEDITOR.document,
				mainWindow = mainDocument.getWindow();

			// Saved selection and scroll position for the editing area.
			var savedSelection, savedScroll;

			// Saved scroll position for the outer window.
			var outerScroll;

			// Saved resize handler function.
			function resizeHandler() {
				var viewPaneSize = mainWindow.getViewPaneSize();
				editor.resize( viewPaneSize.width, viewPaneSize.height, null, true );
			}

			// Retain state after mode switches.
			var savedState = CKEDITOR.TRISTATE_OFF;

			var maximizeElements = [];

			var command = editor.addCommand( 'maximize', {
				// Disabled on iOS (#8307).
				modes: { wysiwyg: !CKEDITOR.env.iOS, source: !CKEDITOR.env.iOS },
				readOnly: 1,
				editorFocus: false,
				exec: function(editor, isDestroy) {
					if (isDestroy && this.state !== CKEDITOR.TRISTATE_ON) {
						return;
					}

					var container = editor.container.getFirst( function( node ) {
						return node.type == CKEDITOR.NODE_ELEMENT && node.hasClass( 'cke_inner' );
					} );
					var contents = editor.ui.space( 'contents' );
					var ignoredClasses = editor.config.maximizeIgnoredClasses;

					// Save current selection and scroll position in editing area.
					if ( editor.mode == 'wysiwyg' ) {
						var selection = editor.getSelection();
						savedSelection = selection && selection.getRanges();
						savedScroll = mainWindow.getScrollPosition();
					} else {
						var $textarea = editor.editable().$;
						savedSelection = !CKEDITOR.env.ie && [ $textarea.selectionStart, $textarea.selectionEnd ];
						savedScroll = [ $textarea.scrollLeft, $textarea.scrollTop ];
					}

					// Go fullscreen if the state is off.
					if ( this.state == CKEDITOR.TRISTATE_OFF ) {
						// Add event handler for resizing.
						mainWindow.on( 'resize', resizeHandler );

						// Save the scroll bar position.
						outerScroll = mainWindow.getScrollPosition();

						// Save and reset the styles for the entire node tree.
						maximizeElements = [];
						var currentNode = editor.container;
						while ( ( currentNode = currentNode.getParent() ) ) {
							maximizeElements.push(currentNode);
							currentNode.setCustomData( 'maximize_saved_styles', saveStyles( currentNode, false, ignoredClasses ) );
							// Show under floatpanels (-1) and context menu (-2).
							currentNode.setStyle( 'z-index', editor.config.baseFloatZIndex - 5 );
						}
						contents.setCustomData( 'maximize_saved_styles', saveStyles( contents, true, ignoredClasses ) );
						container.setCustomData( 'maximize_saved_styles', saveStyles( container, true, ignoredClasses ) );

						// Hide scroll bars.
						var styles = {
							overflow: CKEDITOR.env.webkit ? '' : 'hidden', // #6896
							width: 0,
							height: 0
						};

						var htmlElement = mainDocument.getDocumentElement();
						htmlElement.addClass('cke_editor_maximized');
						htmlElement.setStyles( styles );

						if (!CKEDITOR.env.gecko) {
							htmlElement.setStyle( 'position', 'fixed' );
						}

						if (!(CKEDITOR.env.gecko && CKEDITOR.env.quirks)) {
							mainDocument.getBody().setStyles( styles );
						}

						// Scroll to the top left (IE needs some time for it - #4923).
						CKEDITOR.env.ie ? setTimeout( function() {
							mainWindow.$.scrollTo( 0, 0 );
						}, 0 ) : mainWindow.$.scrollTo( 0, 0 );

						// Resize and move to top left.
						// Special treatment for FF Quirks (#7284)
						container.setStyle( 'position', 'fixed' );
						container.$.offsetLeft; // SAFARI BUG: See #2066.
						container.setStyles( {
							// Show under floatpanels (-1) and context menu (-2).
							'z-index': editor.config.baseFloatZIndex - 5,
							left: '0px',
							top: '0px'
						} );

						// Add cke_maximized class before resize handle since that will change things sizes (#5580)
						container.addClass( 'cke_maximized' );

						resizeHandler();
						editor._maximizeResizeTimeout = setTimeout(function() {
							resizeHandler();
						}, 0);

						// Still not top left? Fix it. (Bug #174)
						var offset = container.getDocumentPosition();
						container.setStyles( {
							left: ( -1 * offset.x ) + 'px',
							top: ( -1 * offset.y ) + 'px'
						} );

						// Fixing positioning editor chrome in Firefox break design mode. (#5149)
						CKEDITOR.env.gecko && refreshCursor( editor );
					}
					// Restore from fullscreen if the state is on.
					else if ( this.state == CKEDITOR.TRISTATE_ON ) {
						clearTimeout(editor._maximizeResizeTimeout);

						// Remove event handler for resizing.
						mainWindow.removeListener( 'resize', resizeHandler );

						// Restore CSS styles for the entire node tree.
						var editorElements = [ contents, container ];
						for ( var i = 0; i < editorElements.length; i++ ) {
							if (!editorElements[ i ]) {
								continue;
							}

							restoreStyles( editorElements[ i ], editorElements[ i ].getCustomData( 'maximize_saved_styles' ) );
							editorElements[ i ].removeCustomData( 'maximize_saved_styles' );
						}

						while ( ( currentNode = maximizeElements.pop() ) ) {
							restoreStyles( currentNode, currentNode.getCustomData( 'maximize_saved_styles' ) );
							currentNode.removeCustomData( 'maximize_saved_styles' );
						}

						// Restore the window scroll position.
						CKEDITOR.env.ie ? setTimeout( function() {
							mainWindow.$.scrollTo( outerScroll.x, outerScroll.y );
						}, 0 ) : mainWindow.$.scrollTo( outerScroll.x, outerScroll.y );

						// Remove cke_maximized class.
						container.removeClass( 'cke_maximized' );

						// Webkit requires a re-layout on editor chrome. (#6695)
						if ( CKEDITOR.env.webkit ) {
							container.setStyle( 'display', 'inline' );
							setTimeout( function() {
								container.setStyle( 'display', 'block' );
							}, 0 );
						}

						if (!isDestroy) {
							// Emit a resize event, because this time the size is modified in
							// restoreStyles.
							editor.fire( 'resize', {
								outerHeight: editor.container.$.offsetHeight,
								contentsHeight: contents.$.offsetHeight,
								outerWidth: editor.container.$.offsetWidth
							} );
						}
					}

					this.toggleState();

					if (!isDestroy) {
						// Toggle button label.
						var button = this.uiItems[ 0 ];
						// Only try to change the button if it exists (#6166)
						if ( button ) {
							var label = ( this.state == CKEDITOR.TRISTATE_OFF ) ? lang.maximize.maximize : lang.maximize.minimize;
							var buttonNode = CKEDITOR.document.getById( button._.id );
							buttonNode.getChild( 1 ).setHtml( label );
							buttonNode.setAttribute( 'title', label );
							buttonNode.setAttribute( 'href', 'javascript:void("' + label + '");' ); // jshint ignore:line
						}

						// Restore selection and scroll position in editing area.
						if ( editor.mode == 'wysiwyg' ) {
							if ( savedSelection ) {
								// Fixing positioning editor chrome in Firefox break design mode. (#5149)
								CKEDITOR.env.gecko && refreshCursor( editor );

								editor.getSelection().selectRanges( savedSelection );
								var element = editor.getSelection().getStartElement();
								element && element.scrollIntoView( true );
							} else {
								mainWindow.$.scrollTo( savedScroll.x, savedScroll.y );
							}
						} else {
							if ( savedSelection ) {
								$textarea.selectionStart = savedSelection[ 0 ];
								$textarea.selectionEnd = savedSelection[ 1 ];
							}
							$textarea.scrollLeft = savedScroll[ 0 ];
							$textarea.scrollTop = savedScroll[ 1 ];
						}
					}

					savedSelection = savedScroll = null;
					savedState = this.state;

					if (!isDestroy) {
						editor.fire( 'maximize', this.state );
					}
				},
				canUndo: false
			} );

			command.on('state', function() {
				if (this.state === CKEDITOR.TRISTATE_OFF) {
					var evt = CKEDITOR.document.$.createEvent('Event');
					evt.initEvent('resize', true, true);
					evt.data = { 'custom': true };
					CKEDITOR.document.getWindow().$.dispatchEvent(evt)
				}
			});

			editor.ui.addButton && editor.ui.addButton( 'Maximize', {
				label: lang.maximize.maximize,
				command: 'maximize',
				toolbar: 'tools,10'
			} );

			// Restore the command state after mode change, unless it has been changed to disabled (#6467)
			editor.on( 'mode', function() {
				var command = editor.getCommand( 'maximize' );
				command.setState( command.state == CKEDITOR.TRISTATE_DISABLED ? CKEDITOR.TRISTATE_DISABLED : savedState );
			}, null, null, 100 );

			editor.on( 'beforeDestroy', function() {
				editor.execCommand( 'maximize', true );
			} );
		}
	} );
} )();

/**
 * Event fired when the maximize command is called.
 * It also indicates whether an editor is maximized or not.
 *
 * @event maximize
 * @member CKEDITOR.editor
 * @param {CKEDITOR.editor} editor This editor instance.
 * @param {Number} data Current state of the command. See {@link CKEDITOR#TRISTATE_ON} and {@link CKEDITOR#TRISTATE_OFF}.
 */
