export default function applyStaticConfigs(config) {
    applyColorButtonStaticConfig(config);
    applyFontStaticConfig(config);
    applyFormatStaticConfig(config);
    applyRichComboStaticConfig(config);
    applyWysiwygAreaStaticConfig(config);
}

function applyColorButtonStaticConfig(config) {
    config.colorButton_colors = '000,800000,8B4513,2F4F4F,008080,000080,4B0082,696969,' +
        'B22222,A52A2A,DAA520,006400,40E0D0,0000CD,800080,808080,' +
        'F00,FF8C00,FFD700,008000,0FF,00F,EE82EE,A9A9A9,' +
        'FFA07A,FFA500,FFFF00,00FF00,AFEEEE,ADD8E6,DDA0DD,D3D3D3,' +
        'FFF0F5,FAEBD7,FFFFE0,F0FFF0,F0FFFF,F0F8FF,E6E6FA,FFF';

    config.colorButton_foreStyle = {
        element: 'span',
        styles: { 'color': '#(color)' },
        overrides: [ {
            element: 'font', attributes: { 'color': null }
        } ]
    };

    config.colorButton_backStyle = {
        element: 'span',
        styles: { 'background-color': '#(color)' }
    };
}

function applyFontStaticConfig(config) {
    config.font_names = 'Arial/Arial, Helvetica, sans-serif;' +
        'Comic Sans MS/Comic Sans MS, cursive;' +
        'Courier New/Courier New, Courier, monospace;' +
        'Georgia/Georgia, serif;' +
        'Lucida Sans Unicode/Lucida Sans Unicode, Lucida Grande, sans-serif;' +
        'Tahoma/Tahoma, Geneva, sans-serif;' +
        'Times New Roman/Times New Roman, Times, serif;' +
        'Trebuchet MS/Trebuchet MS, Helvetica, sans-serif;' +
        'Verdana/Verdana, Geneva, sans-serif';

    config.font_defaultLabel = '';

    config.font_style = {
        element: 'span',
        styles: { 'font-family': '#(family)' },
        overrides: [ {
            element: 'font', attributes: { 'face': null }
        } ]
    };

    config.fontSize_sizes = '8/8px;9/9px;10/10px;11/11px;'
        + '12/12px;14/14px;16/16px;18/18px;20/20px;22/22px;24/24px;'
        + '26/26px;28/28px;36/36px;48/48px;72/72px';

    config.fontSize_defaultLabel = '';

    config.fontSize_style = {
        element: 'span',
        styles: { 'font-size': '#(size)' },
        overrides: [ {
            element: 'font', attributes: { 'size': null }
        } ]
    };
}

function applyFormatStaticConfig(config) {
    config.format_tags = 'p;h1;h2;h3;h4;h5;h6;pre;address;div';
    config.format_p = { element: 'p' };
    config.format_div = { element: 'div' };
    config.format_pre = { element: 'pre' };
    config.format_address = { element: 'address' };
    config.format_h1 = { element: 'h1' };
    config.format_h2 = { element: 'h2' };
    config.format_h3 = { element: 'h3' };
    config.format_h4 = { element: 'h4' };
    config.format_h5 = { element: 'h5' };
    config.format_h6 = { element: 'h6' };
}

function applyRichComboStaticConfig(config) {
    config.richcombo_showText = false;
}

function applyWysiwygAreaStaticConfig(config) {
    config.disableObjectResizing = false;
    config.disableNativeTableHandles = true;
    config.disableNativeSpellChecker = false;
}
