import React, { useState, ReactNode } from 'react';
import { Roller } from './Roller';

export default {
  title: 'Roller',
  component: Roller,
};

const ARRAY_LENGTH = 20;

export const Default = () => {
  const [hidden, setHidden] = useState<ReactNode>([]);

  return (
    <div>
      <h2>Roller components:</h2>
      <Roller onHiddenComponentsChange={setHidden}>
        {Array.from({ length: ARRAY_LENGTH }).map((item, index) => (
          <div
            key={index}
            style={{ backgroundColor: 'blue', height: 30, minWidth: 60, margin: 10 }}
          />
        ))}
      </Roller>
      <h2>Hidden components:</h2>
      <div style={{ display: 'flex', flexDirection: 'column' }}>{hidden}</div>
    </div>
  );
};
