import React, { ReactElement } from 'react';
import { isFragment, isContextConsumer, isContextProvider } from 'react-is';

export const getElementChildren = (element?: ReactElement) => {
  const elementChildren = element?.props.children;

  if (isContextConsumer(element) && typeof elementChildren === 'function') {
    return elementChildren();
  }

  return elementChildren;
};

export const flatElement = (element: ReactElement) => {
  if (isFragment(element) || isContextConsumer(element) || isContextProvider(element)) {
    return React.Children.map(getElementChildren(element), (child) => flatElement(child));
  }

  return element;
};
